<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);

if (file_exists('vendor/autoload.php')) {
    require_once 'vendor/autoload.php';
}

use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;
use PhpOffice\PhpSpreadsheet\Style\Alignment;
use PhpOffice\PhpSpreadsheet\Style\Font;
use PhpOffice\PhpSpreadsheet\Style\Fill;
use PhpOffice\PhpSpreadsheet\Style\Border;
use PhpOffice\PhpSpreadsheet\Style\Color;
use PhpOffice\PhpSpreadsheet\Style\Conditional;

$host = 'localhost';
$dbname = 'sammscam_qrcode';
$username = 'sammscam_qrcode';
$password = 'PrJ}-eW7AJa5';

try {
    $pdo = new PDO("mysql:host=$host;dbname=$dbname", $username, $password);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} catch (PDOException $e) {
    die("Connection failed: " . $e->getMessage());
}

$regionFilter = isset($_GET['region']) ? trim($_GET['region']) : '';

function getDashboardData($pdo, $regionFilter = '') {
    $data = [];
    
    $regionCondition = '';
    $regionParam = [];
    if ($regionFilter) {
        $regionCondition = " AND region = :region";
        $regionParam = [':region' => $regionFilter];
    }

    $totalQuery = $pdo->prepare("
        SELECT 
            (SELECT COUNT(*) FROM Hpcl_Odisha_QRForm2025 q 
             JOIN Hpcl_Odisha_rolist2025 r ON q.bunkid = r.bunkid 
             WHERE DATE(q.date_time) < CURDATE() AND q.id > 22 $regionCondition) + 
            (SELECT COUNT(*) FROM Hpcl_Odisha_SMSdata2025 s 
             JOIN Hpcl_Odisha_rolist2025 r ON s.bunk_id = r.bunkid 
             WHERE DATE(s.date_time) < CURDATE() $regionCondition) AS total
    ");
    $totalQuery->execute($regionParam);
    $data['total_entries'] = $totalQuery->fetchColumn();
    
    $qrQuery = $pdo->prepare("
        SELECT COUNT(*) FROM Hpcl_Odisha_QRForm2025 q
        JOIN Hpcl_Odisha_rolist2025 r ON q.bunkid = r.bunkid
        WHERE DATE(q.date_time) < CURDATE() AND q.id > 22 $regionCondition
    ");
    $qrQuery->execute($regionParam);
    $data['qr_entries'] = $qrQuery->fetchColumn();
    
    $smsQuery = $pdo->prepare("
        SELECT COUNT(*) FROM Hpcl_Odisha_SMSdata2025 s
        JOIN Hpcl_Odisha_rolist2025 r ON s.bunk_id = r.bunkid
        WHERE DATE(s.date_time) < CURDATE() $regionCondition
    ");
    $smsQuery->execute($regionParam);
    $data['sms_entries'] = $smsQuery->fetchColumn();

    $roStatsQuery = $pdo->prepare("
        SELECT
            COUNT(DISTINCT r.bunkid) AS total_ros,
            COUNT(DISTINCT CASE WHEN (q.bunkid IS NOT NULL AND DATE(q.date_time) < CURDATE() AND q.id > 22) OR 
                                 (s.bunk_id IS NOT NULL AND DATE(s.date_time) < CURDATE()) THEN r.bunkid END) AS active_ros,
            COUNT(DISTINCT r.bunkid) - 
            COUNT(DISTINCT CASE WHEN (q.bunkid IS NOT NULL AND DATE(q.date_time) < CURDATE() AND q.id > 22) OR 
                                 (s.bunk_id IS NOT NULL AND DATE(s.date_time) < CURDATE()) THEN r.bunkid END) AS inactive_ros
        FROM Hpcl_Odisha_rolist2025 r
        LEFT JOIN Hpcl_Odisha_QRForm2025 q ON r.bunkid = q.bunkid AND DATE(q.date_time) < CURDATE() AND q.id > 22
        LEFT JOIN Hpcl_Odisha_SMSdata2025 s ON r.bunkid = s.bunk_id AND DATE(s.date_time) < CURDATE()
        WHERE 1=1 $regionCondition
    ");
    $roStatsQuery->execute($regionParam);
    $ro_stats = $roStatsQuery->fetch();
    $data['active_ros'] = $ro_stats['active_ros'];
    $data['inactive_ros'] = $ro_stats['inactive_ros'];

    $uniqueQuery = $pdo->prepare("
        SELECT COUNT(DISTINCT participant_mobile) FROM (
            SELECT q.mobile AS participant_mobile FROM Hpcl_Odisha_QRForm2025 q
            JOIN Hpcl_Odisha_rolist2025 r ON q.bunkid = r.bunkid
            WHERE q.mobile IS NOT NULL AND q.mobile != '' AND DATE(q.date_time) < CURDATE() AND q.id > 22 $regionCondition
            UNION
            SELECT s.number AS participant_mobile FROM Hpcl_Odisha_SMSdata2025 s
            JOIN Hpcl_Odisha_rolist2025 r ON s.bunk_id = r.bunkid
            WHERE s.number IS NOT NULL AND s.number != '' AND DATE(s.date_time) < CURDATE() $regionCondition
        ) AS t
    ");
    $uniqueQuery->execute($regionParam);
    $data['unique_participants'] = $uniqueQuery->fetchColumn();

    $salesAreasQuery = $pdo->prepare("
        SELECT DISTINCT salesarea FROM Hpcl_Odisha_rolist2025 
        WHERE salesarea IS NOT NULL AND salesarea != '' $regionCondition
    ");
    $salesAreasQuery->execute($regionParam);
    $salesAreas = $salesAreasQuery->fetchAll(PDO::FETCH_COLUMN);

    $data['salesarea_summary_combined'] = [];
    $data['salesarea_summary_qr'] = [];
    $data['salesarea_summary_sms'] = [];

    foreach ($salesAreas as $area) {
        $combined = $pdo->prepare("
            SELECT
                COUNT(DISTINCT bunkid) AS total_bunks,
                (SELECT COUNT(*) FROM Hpcl_Odisha_QRForm2025 q 
                 JOIN Hpcl_Odisha_rolist2025 r2 ON q.bunkid=r2.bunkid 
                 WHERE r2.salesarea=:area AND DATE(q.date_time) < CURDATE() AND q.id > 22 $regionCondition) AS qr_entries,
                (SELECT COUNT(*) FROM Hpcl_Odisha_SMSdata2025 s 
                 JOIN Hpcl_Odisha_rolist2025 r3 ON s.bunk_id=r3.bunkid 
                 WHERE r3.salesarea=:area AND DATE(s.date_time) < CURDATE() $regionCondition) AS sms_entries
            FROM Hpcl_Odisha_rolist2025
            WHERE salesarea=:area $regionCondition
        ");
        $params = [':area' => $area];
        if ($regionFilter) {
            $params[':region'] = $regionFilter;
        }
        $combined->execute($params);
        $c = $combined->fetch();

        $data['salesarea_summary_combined'][] = [
            'salesarea' => $area,
            'total_bunks' => $c['total_bunks'],
            'total_entries' => $c['qr_entries'] + $c['sms_entries'],
            'qr_entries' => $c['qr_entries'],
            'sms_entries' => $c['sms_entries']
        ];
    }

    usort($data['salesarea_summary_combined'], function($a, $b) {
        return $b['total_entries'] <=> $a['total_entries'];
    });

    $dailyQuery = $pdo->prepare("
        SELECT date, SUM(qr_count) AS qr_count, SUM(sms_count) AS sms_count, SUM(qr_count+sms_count) AS total_count
        FROM (
            SELECT DATE(q.date_time) AS date, COUNT(*) AS qr_count, 0 AS sms_count 
            FROM Hpcl_Odisha_QRForm2025 q
            JOIN Hpcl_Odisha_rolist2025 r ON q.bunkid = r.bunkid
            WHERE q.date_time >= DATE_SUB(CURDATE(), INTERVAL 7 DAY) 
            AND q.date_time < CURDATE() 
            AND q.id > 22
            $regionCondition
            GROUP BY DATE(q.date_time)
            UNION ALL
            SELECT DATE(s.date_time) AS date, 0 AS qr_count, COUNT(*) AS sms_count 
            FROM Hpcl_Odisha_SMSdata2025 s
            JOIN Hpcl_Odisha_rolist2025 r ON s.bunk_id = r.bunkid
            WHERE s.date_time >= DATE_SUB(CURDATE(), INTERVAL 7 DAY) 
            AND s.date_time < CURDATE() 
            $regionCondition
            GROUP BY DATE(s.date_time)
        ) AS t
        GROUP BY date
        ORDER BY date
    ");
    $dailyQuery->execute($regionParam);
    $data['daily_entries'] = $dailyQuery->fetchAll(PDO::FETCH_ASSOC);

    $roDetailsQuery = $pdo->prepare("
        SELECT 
            r.bunkid, 
            r.roname, 
            r.salesarea, 
            COALESCE(q.cnt,0)+COALESCE(s.cnt,0) AS total_entries,
            COALESCE(q.cnt,0) AS qr_count,
            COALESCE(s.cnt,0) AS sms_count
        FROM Hpcl_Odisha_rolist2025 r
        LEFT JOIN (
            SELECT bunkid, COUNT(*) AS cnt 
            FROM Hpcl_Odisha_QRForm2025 
            WHERE DATE(date_time) < CURDATE() 
            AND id > 22
            GROUP BY bunkid
        ) q ON r.bunkid=q.bunkid
        LEFT JOIN (
            SELECT bunk_id, COUNT(*) AS cnt 
            FROM Hpcl_Odisha_SMSdata2025 
            WHERE DATE(date_time) < CURDATE() 
            GROUP BY bunk_id
        ) s ON r.bunkid=s.bunk_id
        WHERE 1=1 $regionCondition
        ORDER BY total_entries DESC
    ");
    $roDetailsQuery->execute($regionParam);
    $data['ro_details'] = $roDetailsQuery->fetchAll(PDO::FETCH_ASSOC);

    $inactiveQuery = $pdo->prepare("
        SELECT bunkid, roname, salesarea, 0 AS total_count
        FROM Hpcl_Odisha_rolist2025
        WHERE bunkid NOT IN (
            SELECT DISTINCT q.bunkid FROM Hpcl_Odisha_QRForm2025 q
            JOIN Hpcl_Odisha_rolist2025 r2 ON q.bunkid = r2.bunkid
            WHERE DATE(q.date_time) < CURDATE() AND q.id > 22 $regionCondition
            UNION
            SELECT DISTINCT s.bunk_id FROM Hpcl_Odisha_SMSdata2025 s
            JOIN Hpcl_Odisha_rolist2025 r2 ON s.bunk_id = r2.bunkid
            WHERE DATE(s.date_time) < CURDATE() $regionCondition
        )
        $regionCondition
        ORDER BY salesarea, roname
    ");
    $inactiveQuery->execute($regionParam);
    $data['inactive_ros_list'] = $inactiveQuery->fetchAll(PDO::FETCH_ASSOC);

    return $data;
}

if (isset($_GET['export']) && $_GET['export'] === 'excel') {
    if (!file_exists('vendor/autoload.php')) {
        die('PhpSpreadsheet library not found. Please install it using: composer require phpoffice/phpspreadsheet');
    }

    $dashboardData = getDashboardData($pdo, $regionFilter);
    
    $spreadsheet = new Spreadsheet();
    $spreadsheet->removeSheetByIndex(0);

    $headerStyle = [
        'font' => ['bold' => true, 'color' => ['rgb' => 'FFFFFF'], 'size' => 11],
        'fill' => ['fillType' => Fill::FILL_SOLID, 'startColor' => ['rgb' => '4472C4']],
        'alignment' => ['horizontal' => Alignment::HORIZONTAL_CENTER, 'vertical' => Alignment::VERTICAL_CENTER],
        'borders' => ['allBorders' => ['borderStyle' => Border::BORDER_THIN, 'color' => ['rgb' => '000000']]]
    ];
    
    $titleStyle = [
        'font' => ['bold' => true, 'size' => 14, 'color' => ['rgb' => '1F497D']],
        'alignment' => ['horizontal' => Alignment::HORIZONTAL_CENTER]
    ];
    
    $dataStyle = [
        'borders' => ['allBorders' => ['borderStyle' => Border::BORDER_THIN, 'color' => ['rgb' => 'BFBFBF']]],
        'alignment' => ['horizontal' => Alignment::HORIZONTAL_CENTER, 'vertical' => Alignment::VERTICAL_CENTER]
    ];
    
    $highlightStyle = [
        'fill' => ['fillType' => Fill::FILL_SOLID, 'startColor' => ['rgb' => 'E2EFDA']]
    ];

    $summarySheet = $spreadsheet->createSheet();
    $summarySheet->setTitle('Summary Statistics');
    
    $titleText = 'IOCL Warangal Campaign - Summary Statistics';
    if ($regionFilter) {
        $titleText .= ' (Region: ' . $regionFilter . ')';
    }
    $summarySheet->setCellValue('A1', $titleText);
    $summarySheet->mergeCells('A1:B1');
    $summarySheet->getStyle('A1')->applyFromArray($titleStyle);
    
    $summarySheet->setCellValue('A3', 'Metric');
    $summarySheet->setCellValue('B3', 'Value');
    $summarySheet->getStyle('A3:B3')->applyFromArray($headerStyle);
    
    $summaryData = [
        ['Total Entries (QR+SMS)', $dashboardData['total_entries']],
        ['QR Code Entries', $dashboardData['qr_entries']],
        ['SMS Entries', $dashboardData['sms_entries']],
        ['Active ROs', $dashboardData['active_ros']],
        ['Inactive ROs', $dashboardData['inactive_ros']],
        ['Unique Participants', $dashboardData['unique_participants']]
    ];
    
    if ($regionFilter) {
        $summaryData[] = ['Filtered Region', $regionFilter];
    }
    
    $row = 4;
    foreach ($summaryData as $data) {
        $summarySheet->setCellValue('A' . $row, $data[0]);
        $summarySheet->setCellValue('B' . $row, $data[1]);
        $row++;
    }
    
    $summarySheet->getStyle('A4:B' . ($row - 1))->applyFromArray($dataStyle);
    for ($i = 4; $i < $row; $i += 2) {
        $summarySheet->getStyle('A' . $i . ':B' . $i)->applyFromArray($highlightStyle);
    }
    
    $startRow = $row + 2;
    
    $regionCondition = '';
    $regionParam = [];
    if ($regionFilter) {
        $regionCondition = " AND region = :region";
        $regionParam = [':region' => $regionFilter];
    }
    
    $campaignDaysQuery = $pdo->prepare("
        SELECT DATEDIFF(CURDATE(), DATE(MIN(date_time))) + 1 AS days
        FROM (
            SELECT q.date_time FROM Hpcl_Odisha_QRForm2025 q
            JOIN Hpcl_Odisha_rolist2025 r ON q.bunkid = r.bunkid
            WHERE q.id > 22 $regionCondition
            UNION ALL
            SELECT s.date_time FROM Hpcl_Odisha_SMSdata2025 s
            JOIN Hpcl_Odisha_rolist2025 r ON s.bunk_id = r.bunkid
            WHERE 1=1 $regionCondition
        ) AS combined
    ");
    $campaignDaysQuery->execute($regionParam);
    $campaignDays = $campaignDaysQuery->fetchColumn();
    
    $totalROsQuery = $pdo->prepare("SELECT COUNT(*) FROM Hpcl_Odisha_rolist2025 WHERE 1=1 $regionCondition");
    $totalROsQuery->execute($regionParam);
    $totalROs = $totalROsQuery->fetchColumn();
    
    $qrActiveROsQuery = $pdo->prepare("
        SELECT COUNT(DISTINCT q.bunkid) FROM Hpcl_Odisha_QRForm2025 q
        JOIN Hpcl_Odisha_rolist2025 r ON q.bunkid = r.bunkid
        WHERE DATE(q.date_time) < CURDATE() AND q.id > 22 $regionCondition
    ");
    $qrActiveROsQuery->execute($regionParam);
    $qrActiveROs = $qrActiveROsQuery->fetchColumn();
    
    $smsActiveROsQuery = $pdo->prepare("
        SELECT COUNT(DISTINCT s.bunk_id) FROM Hpcl_Odisha_SMSdata2025 s
        JOIN Hpcl_Odisha_rolist2025 r ON s.bunk_id = r.bunkid
        WHERE DATE(s.date_time) < CURDATE() $regionCondition
    ");
    $smsActiveROsQuery->execute($regionParam);
    $smsActiveROs = $smsActiveROsQuery->fetchColumn();
    
    $qrTotalCount = $dashboardData['qr_entries'];
    $smsTotalCount = $dashboardData['sms_entries'];
    $combinedTotalCount = $dashboardData['total_entries'];
    
    $summarySheet->setCellValue('A' . $startRow, 'Cumulative Summary');
    $summarySheet->mergeCells('A' . $startRow . ':B' . $startRow);
    $summarySheet->getStyle('A' . $startRow)->applyFromArray([
        'font' => ['bold' => true, 'color' => ['rgb' => 'FFFFFF'], 'size' => 11],
        'fill' => ['fillType' => Fill::FILL_SOLID, 'startColor' => ['rgb' => '5B9BD5']],
        'alignment' => ['horizontal' => Alignment::HORIZONTAL_CENTER]
    ]);
    
    $summarySheet->setCellValue('D' . $startRow, 'QR Summary');
    $summarySheet->mergeCells('D' . $startRow . ':E' . $startRow);
    $summarySheet->getStyle('D' . $startRow)->applyFromArray([
        'font' => ['bold' => true, 'color' => ['rgb' => 'FFFFFF'], 'size' => 11],
        'fill' => ['fillType' => Fill::FILL_SOLID, 'startColor' => ['rgb' => '5B9BD5']],
        'alignment' => ['horizontal' => Alignment::HORIZONTAL_CENTER]
    ]);
    
    $summarySheet->setCellValue('G' . $startRow, 'SMS Summary');
    $summarySheet->mergeCells('G' . $startRow . ':H' . $startRow);
    $summarySheet->getStyle('G' . $startRow)->applyFromArray([
        'font' => ['bold' => true, 'color' => ['rgb' => 'FFFFFF'], 'size' => 11],
        'fill' => ['fillType' => Fill::FILL_SOLID, 'startColor' => ['rgb' => '5B9BD5']],
        'alignment' => ['horizontal' => Alignment::HORIZONTAL_CENTER]
    ]);
    
    $cumulativeData = [
        ['No. of Days', $campaignDays ?: 9],
        ['No. of Participating RO\'s', $totalROs],
        ['RO\'s Active', $dashboardData['active_ros']],
        ['RO\'s Inactive', $dashboardData['inactive_ros']],
        ['Total count as on date', $combinedTotalCount]
    ];
    
    $qrData = [
        ['No. of Days', $campaignDays ?: 9],
        ['No. of Participating RO\'s', $totalROs],
        ['RO\'s Active', $qrActiveROs],
        ['RO\'s Inactive', $totalROs - $qrActiveROs],
        ['Total count as on date', $qrTotalCount]
    ];
    
    $smsData = [
        ['No. of Days', $campaignDays ?: 9],
        ['No. of Participating RO\'s', $totalROs],
        ['RO\'s Active', $smsActiveROs],
        ['RO\'s Inactive', $totalROs - $smsActiveROs],
        ['Total count as on date', $smsTotalCount]
    ];
    
    for ($i = 0; $i < count($cumulativeData); $i++) {
        $currentRow = $startRow + 1 + $i;
        
        $summarySheet->setCellValue('A' . $currentRow, $cumulativeData[$i][0]);
        $summarySheet->setCellValue('B' . $currentRow, $cumulativeData[$i][1]);
        
        $summarySheet->setCellValue('D' . $currentRow, $qrData[$i][0]);
        $summarySheet->setCellValue('E' . $currentRow, $qrData[$i][1]);
        
        $summarySheet->setCellValue('G' . $currentRow, $smsData[$i][0]);
        $summarySheet->setCellValue('H' . $currentRow, $smsData[$i][1]);
        
        if ($cumulativeData[$i][0] === 'RO\'s Inactive') {
            $summarySheet->getStyle('A' . $currentRow . ':B' . $currentRow)->getFont()->getColor()->setRGB('FF0000');
            $summarySheet->getStyle('D' . $currentRow . ':E' . $currentRow)->getFont()->getColor()->setRGB('FF0000');
            $summarySheet->getStyle('G' . $currentRow . ':H' . $currentRow)->getFont()->getColor()->setRGB('FF0000');
        }
    }
    
    $endRow = $startRow + count($cumulativeData);
    $summarySheet->getStyle('A' . ($startRow + 1) . ':B' . $endRow)->applyFromArray($dataStyle);
    $summarySheet->getStyle('D' . ($startRow + 1) . ':E' . $endRow)->applyFromArray($dataStyle);
    $summarySheet->getStyle('G' . ($startRow + 1) . ':H' . $endRow)->applyFromArray($dataStyle);
    
    $summarySheet->getColumnDimension('A')->setWidth(30);
    $summarySheet->getColumnDimension('B')->setWidth(18);
    $summarySheet->getColumnDimension('D')->setWidth(30);
    $summarySheet->getColumnDimension('E')->setWidth(18);
    $summarySheet->getColumnDimension('G')->setWidth(30);
    $summarySheet->getColumnDimension('H')->setWidth(18);

    $topROSheet = $spreadsheet->createSheet();
    $topROSheet->setTitle('Top Performing ROs');

    $titleText = 'Top Performing ROs by Sales Area';
    if ($regionFilter) {
        $titleText .= ' (Region: ' . $regionFilter . ')';
    }
    $topROSheet->setCellValue('A1', $titleText);
    $topROSheet->mergeCells('A1:I1');
    $topROSheet->getStyle('A1')->applyFromArray($titleStyle);

    $salesAreasQuery = $pdo->prepare("
        SELECT DISTINCT salesarea 
        FROM Hpcl_Odisha_rolist2025 
        WHERE salesarea IS NOT NULL AND salesarea != '' $regionCondition
        ORDER BY salesarea
    ");
    $salesAreasQuery->execute($regionParam);
    $salesAreas = $salesAreasQuery->fetchAll(PDO::FETCH_COLUMN);

    $currentRow = 3;
    $chartDataArray = [];

    foreach ($salesAreas as $salesArea) {
        $topROSheet->setCellValue('A' . $currentRow, $salesArea);
        $topROSheet->mergeCells('A' . $currentRow . ':G' . $currentRow);
        $topROSheet->getStyle('A' . $currentRow . ':G' . $currentRow)->applyFromArray([
            'font' => ['bold' => true, 'color' => ['rgb' => 'FFFFFF'], 'size' => 11],
            'fill' => ['fillType' => Fill::FILL_SOLID, 'startColor' => ['rgb' => '5B9BD5']],
            'alignment' => ['horizontal' => Alignment::HORIZONTAL_CENTER]
        ]);
        
        $currentRow++;
        
        $headers = ['Rank', 'BUNK ID', 'RO Name', 'QR Count', 'SMS Count', 'Total Entries', '% of Area Total'];
        $col = 'A';
        foreach ($headers as $header) {
            $topROSheet->setCellValue($col . $currentRow, $header);
            $col++;
        }
        $topROSheet->getStyle('A' . $currentRow . ':G' . $currentRow)->applyFromArray($headerStyle);
        
        $currentRow++;
        
        $topROsQuery = $pdo->prepare("
            SELECT 
                r.bunkid, 
                r.roname, 
                COALESCE(q.qr_count, 0) AS qr_count,
                COALESCE(s.sms_count, 0) AS sms_count,
                COALESCE(q.qr_count, 0) + COALESCE(s.sms_count, 0) AS total_entries
            FROM Hpcl_Odisha_rolist2025 r
            LEFT JOIN (
                SELECT bunkid, COUNT(*) AS qr_count 
                FROM Hpcl_Odisha_QRForm2025 
                WHERE DATE(date_time) < CURDATE() AND id > 22
                GROUP BY bunkid
            ) q ON r.bunkid = q.bunkid
            LEFT JOIN (
                SELECT bunk_id, COUNT(*) AS sms_count 
                FROM Hpcl_Odisha_SMSdata2025 
                WHERE DATE(date_time) < CURDATE()
                GROUP BY bunk_id
            ) s ON r.bunkid = s.bunk_id
            WHERE r.salesarea = :salesarea
            ORDER BY total_entries DESC
            LIMIT 10
        ");
        $topROsQuery->execute([':salesarea' => $salesArea]);
        $topROs = $topROsQuery->fetchAll(PDO::FETCH_ASSOC);
        
        $areaTotalQuery = $pdo->prepare("
            SELECT 
                (SELECT COUNT(*) FROM Hpcl_Odisha_QRForm2025 q 
                 JOIN Hpcl_Odisha_rolist2025 r2 ON q.bunkid = r2.bunkid 
                 WHERE r2.salesarea = :salesarea AND DATE(q.date_time) < CURDATE() AND q.id > 22) +
                (SELECT COUNT(*) FROM Hpcl_Odisha_SMSdata2025 s 
                 JOIN Hpcl_Odisha_rolist2025 r2 ON s.bunk_id = r2.bunkid 
                 WHERE r2.salesarea = :salesarea AND DATE(s.date_time) < CURDATE()) AS area_total
        ");
        $areaTotalQuery->execute([':salesarea' => $salesArea]);
        $areaTotal = $areaTotalQuery->fetchColumn();
        
        $rank = 1;
        $areaQRTotal = 0;
        $areaSMSTotal = 0;
        $areaEntriesTotal = 0;
        $chartData = [];
        
        foreach ($topROs as $ro) {
            $topROSheet->setCellValue('A' . $currentRow, $rank);
            $topROSheet->setCellValue('B' . $currentRow, $ro['bunkid']);
            $topROSheet->setCellValue('C' . $currentRow, $ro['roname']);
            $topROSheet->setCellValue('D' . $currentRow, $ro['qr_count']);
            $topROSheet->setCellValue('E' . $currentRow, $ro['sms_count']);
            $topROSheet->setCellValue('F' . $currentRow, $ro['total_entries']);
            
            $percentage = $areaTotal > 0 ? round(($ro['total_entries'] / $areaTotal) * 100, 1) : 0;
            $topROSheet->setCellValue('G' . $currentRow, $percentage . '%');
            
            $chartData[] = [
                'name' => $ro['roname'],
                'value' => $ro['total_entries'],
                'percentage' => $percentage
            ];
            
            $areaQRTotal += $ro['qr_count'];
            $areaSMSTotal += $ro['sms_count'];
            $areaEntriesTotal += $ro['total_entries'];
            
            if ($rank % 2 == 0) {
                $topROSheet->getStyle('A' . $currentRow . ':G' . $currentRow)->applyFromArray($highlightStyle);
            }
            
            $currentRow++;
            $rank++;
        }
        
        $chartDataArray[$salesArea] = $chartData;
        
        $topROSheet->setCellValue('A' . $currentRow, 'SUBTOTAL');
        $topROSheet->mergeCells('A' . $currentRow . ':C' . $currentRow);
        $topROSheet->getStyle('A' . $currentRow . ':C' . $currentRow)->getAlignment()->setHorizontal(Alignment::HORIZONTAL_RIGHT);
        $topROSheet->setCellValue('D' . $currentRow, $areaQRTotal);
        $topROSheet->setCellValue('E' . $currentRow, $areaSMSTotal);
        $topROSheet->setCellValue('F' . $currentRow, $areaEntriesTotal);
        
        $subtotalPercentage = $areaTotal > 0 ? round(($areaEntriesTotal / $areaTotal) * 100, 1) : 0;
        $topROSheet->setCellValue('G' . $currentRow, $subtotalPercentage . '%');
        
        $topROSheet->getStyle('A' . $currentRow . ':G' . $currentRow)->applyFromArray([
            'font' => ['bold' => true, 'italic' => true],
            'fill' => [
                'fillType' => Fill::FILL_SOLID,
                'startColor' => ['rgb' => 'E2EFDA']
            ],
            'borders' => [
                'top' => [
                    'borderStyle' => Border::BORDER_THIN,
                    'color' => ['rgb' => '000000']
                ]
            ]
        ]);
        
        $currentRow += 2;
    }

    $currentRow++;
    $topROSheet->setCellValue('A' . $currentRow, 'GRAND TOTAL - ALL AREAS');
    if ($regionFilter) {
        $topROSheet->setCellValue('A' . $currentRow, 'GRAND TOTAL - REGION: ' . $regionFilter);
    }
    $topROSheet->mergeCells('A' . $currentRow . ':C' . $currentRow);
    $topROSheet->getStyle('A' . $currentRow . ':C' . $currentRow)->getAlignment()->setHorizontal(Alignment::HORIZONTAL_RIGHT);

    $grandTotalQuery = $pdo->prepare("
        SELECT 
            (SELECT COUNT(*) FROM Hpcl_Odisha_QRForm2025 q
             JOIN Hpcl_Odisha_rolist2025 r ON q.bunkid = r.bunkid
             WHERE DATE(q.date_time) < CURDATE() AND q.id > 22 $regionCondition) AS qr_total,
            (SELECT COUNT(*) FROM Hpcl_Odisha_SMSdata2025 s
             JOIN Hpcl_Odisha_rolist2025 r ON s.bunk_id = r.bunkid
             WHERE DATE(s.date_time) < CURDATE() $regionCondition) AS sms_total
    ");
    $grandTotalQuery->execute($regionParam);
    $grandTotals = $grandTotalQuery->fetch();

    $topROSheet->setCellValue('D' . $currentRow, $grandTotals['qr_total']);
    $topROSheet->setCellValue('E' . $currentRow, $grandTotals['sms_total']);
    $topROSheet->setCellValue('F' . $currentRow, $grandTotals['qr_total'] + $grandTotals['sms_total']);
    $topROSheet->setCellValue('G' . $currentRow, '100%');

    $topROSheet->getStyle('A' . $currentRow . ':G' . $currentRow)->applyFromArray([
        'font' => ['bold' => true, 'color' => ['rgb' => 'FFFFFF']],
        'fill' => [
            'fillType' => Fill::FILL_SOLID,
            'startColor' => ['rgb' => '4472C4']
        ],
        'borders' => [
            'allBorders' => [
                'borderStyle' => Border::BORDER_MEDIUM,
                'color' => ['rgb' => '000000']
            ]
        ]
    ]);

    $topROSheet->getStyle('A3:G' . $currentRow)->applyFromArray($dataStyle);

    $topROSheet->getColumnDimension('A')->setWidth(8);
    $topROSheet->getColumnDimension('B')->setWidth(12);
    $topROSheet->getColumnDimension('C')->setWidth(35);
    $topROSheet->getColumnDimension('D')->setWidth(12);
    $topROSheet->getColumnDimension('E')->setWidth(12);
    $topROSheet->getColumnDimension('F')->setWidth(15);
    $topROSheet->getColumnDimension('G')->setWidth(15);

    $chartStartColumn = 'J';
    $chartRow = 3;

    $topROSheet->setCellValue($chartStartColumn . '1', 'Performance Charts by Sales Area');
    $topROSheet->mergeCells($chartStartColumn . '1:N1');
    $topROSheet->getStyle($chartStartColumn . '1')->applyFromArray([
        'font' => ['bold' => true, 'size' => 14, 'color' => ['rgb' => '1F497D']],
        'alignment' => ['horizontal' => Alignment::HORIZONTAL_CENTER]
    ]);

    foreach ($salesAreas as $index => $salesArea) {
        if (!empty($chartDataArray[$salesArea])) {
            $topROSheet->setCellValue($chartStartColumn . $chartRow, $salesArea . ' - Top 10 ROs Performance');
            $topROSheet->mergeCells($chartStartColumn . $chartRow . ':N' . $chartRow);
            $topROSheet->getStyle($chartStartColumn . $chartRow)->applyFromArray([
                'font' => ['bold' => true, 'size' => 11],
                'fill' => ['fillType' => Fill::FILL_SOLID, 'startColor' => ['rgb' => '5B9BD5']],
                'alignment' => ['horizontal' => Alignment::HORIZONTAL_CENTER]
            ]);
            
            $chartRow++;
            
            $topROSheet->setCellValue($chartStartColumn . $chartRow, 'RO Name');
            $topROSheet->setCellValue('K' . $chartRow, 'Entries');
            $topROSheet->setCellValue('L' . $chartRow, 'Visual Bar');
            $topROSheet->setCellValue('N' . $chartRow, '%');
            $topROSheet->getStyle($chartStartColumn . $chartRow . ':N' . $chartRow)->applyFromArray([
                'font' => ['bold' => true],
                'fill' => ['fillType' => Fill::FILL_SOLID, 'startColor' => ['rgb' => 'D9E1F2']],
                'borders' => ['allBorders' => ['borderStyle' => Border::BORDER_THIN]]
            ]);
            
            $chartRow++;
            
            $maxValue = max(array_column($chartDataArray[$salesArea], 'value'));
            
            foreach ($chartDataArray[$salesArea] as $data) {
                $topROSheet->setCellValue($chartStartColumn . $chartRow, $data['name']);
                $topROSheet->setCellValue('K' . $chartRow, $data['value']);
                
                $barLength = $maxValue > 0 ? round(($data['value'] / $maxValue) * 20) : 0;
                $bar = str_repeat('█', $barLength);
                $topROSheet->setCellValue('L' . $chartRow, $bar);
                $topROSheet->mergeCells('L' . $chartRow . ':M' . $chartRow);
                
                if ($barLength >= 15) {
                    $barColor = '70AD47';
                } elseif ($barLength >= 10) {
                    $barColor = 'FFC000';
                } else {
                    $barColor = 'FF0000';
                }
                
                $topROSheet->getStyle('L' . $chartRow . ':M' . $chartRow)->applyFromArray([
                    'font' => ['color' => ['rgb' => $barColor]],
                    'alignment' => ['horizontal' => Alignment::HORIZONTAL_LEFT]
                ]);
                
                $topROSheet->setCellValue('N' . $chartRow, $data['percentage'] . '%');
                
                $topROSheet->getStyle($chartStartColumn . $chartRow . ':N' . $chartRow)->applyFromArray([
                    'borders' => ['allBorders' => ['borderStyle' => Border::BORDER_THIN, 'color' => ['rgb' => 'BFBFBF']]]
                ]);
                
                $chartRow++;
            }
            
            $chartRow += 2;
        }
    }

    $topROSheet->getColumnDimension($chartStartColumn)->setWidth(30);
    $topROSheet->getColumnDimension('K')->setWidth(10);
    $topROSheet->getColumnDimension('L')->setWidth(15);
    $topROSheet->getColumnDimension('M')->setWidth(5);
    $topROSheet->getColumnDimension('N')->setWidth(8);

    $noteRow = $currentRow + 3;
    $noteText = 'Note: Performance data excludes today\'s entries and first 22 QR test entries.';
    if ($regionFilter) {
        $noteText .= ' Data filtered for region: ' . $regionFilter . '.';
    }
    $topROSheet->setCellValue('A' . $noteRow, $noteText);
    $topROSheet->mergeCells('A' . $noteRow . ':G' . $noteRow);
    $topROSheet->getStyle('A' . $noteRow)->applyFromArray([
        'font' => ['italic' => true, 'size' => 9, 'color' => ['rgb' => '7F7F7F']],
        'alignment' => ['horizontal' => Alignment::HORIZONTAL_LEFT]
    ]);

    $summaryRow = $chartRow + 2;
    $topROSheet->setCellValue($chartStartColumn . $summaryRow, 'OVERALL SUMMARY');
    $topROSheet->mergeCells($chartStartColumn . $summaryRow . ':N' . $summaryRow);
    $topROSheet->getStyle($chartStartColumn . $summaryRow)->applyFromArray([
        'font' => ['bold' => true, 'size' => 12],
        'fill' => ['fillType' => Fill::FILL_SOLID, 'startColor' => ['rgb' => '4472C4']],
        'font' => ['bold' => true, 'color' => ['rgb' => 'FFFFFF']],
        'alignment' => ['horizontal' => Alignment::HORIZONTAL_CENTER]
    ]);

    $summaryRow++;
    $topROSheet->setCellValue($chartStartColumn . $summaryRow, 'Total Sales Areas:');
    $topROSheet->setCellValue('L' . $summaryRow, count($salesAreas));
    $summaryRow++;
    $topROSheet->setCellValue($chartStartColumn . $summaryRow, 'Total Active ROs:');
    $topROSheet->setCellValue('L' . $summaryRow, $dashboardData['active_ros']);
    $summaryRow++;
    $topROSheet->setCellValue($chartStartColumn . $summaryRow, 'Total Entries:');
    $topROSheet->setCellValue('L' . $summaryRow, $grandTotals['qr_total'] + $grandTotals['sms_total']);

    $topROSheet->getStyle($chartStartColumn . ($summaryRow - 3) . ':N' . $summaryRow)->applyFromArray([
        'borders' => ['allBorders' => ['borderStyle' => Border::BORDER_THIN]],
        'font' => ['bold' => true]
    ]);

    $inactiveSheet = $spreadsheet->createSheet();
    $inactiveSheet->setTitle('Inactive ROs');
    
    $titleText = 'Inactive ROs (No QR/SMS entries)';
    if ($regionFilter) {
        $titleText .= ' - Region: ' . $regionFilter;
    }
    $inactiveSheet->setCellValue('A1', $titleText);
    $inactiveSheet->mergeCells('A1:D1');
    $inactiveSheet->getStyle('A1')->applyFromArray($titleStyle);
    
    $inactiveHeaders = ['BUNK ID', 'RO Name', 'Sales Area', 'Total Count'];
    $col = 'A';
    foreach ($inactiveHeaders as $header) {
        $inactiveSheet->setCellValue($col . '3', $header);
        $col++;
    }
    $inactiveSheet->getStyle('A3:D3')->applyFromArray($headerStyle);
    
    $row = 4;
    foreach ($dashboardData['inactive_ros_list'] as $ro) {
        $inactiveSheet->setCellValue('A' . $row, $ro['bunkid']);
        $inactiveSheet->setCellValue('B' . $row, $ro['roname']);
        $inactiveSheet->setCellValue('C' . $row, $ro['salesarea']);
        $inactiveSheet->setCellValue('D' . $row, $ro['total_count']);
        $row++;
    }
    
    $inactiveSheet->getStyle('A4:D' . ($row-1))->applyFromArray($dataStyle);
    for ($i = 4; $i < $row; $i += 2) {
        $inactiveSheet->getStyle('A' . $i . ':D' . $i)->applyFromArray($highlightStyle);
    }
    
    $inactiveSheet->getColumnDimension('A')->setWidth(12);
    $inactiveSheet->getColumnDimension('B')->setWidth(35);
    $inactiveSheet->getColumnDimension('C')->setWidth(25);
    $inactiveSheet->getColumnDimension('D')->setWidth(15);

    $dailySheet = $spreadsheet->createSheet();
    $dailySheet->setTitle('Daily QR Entries');
    
    try {
        $dateQuery = $pdo->prepare("
            SELECT DATE(MIN(q.date_time)) AS min_date 
            FROM Hpcl_Odisha_QRForm2025 q
            JOIN Hpcl_Odisha_rolist2025 r ON q.bunkid = r.bunkid
            WHERE q.id > 22 $regionCondition
        ");
        $dateQuery->execute($regionParam);
        $startDate = $dateQuery->fetchColumn();
        
        if (!$startDate) {
            $dailySheet->setCellValue('A1', 'No QR data available');
            $dailySheet->getStyle('A1')->applyFromArray($titleStyle);
        } else {
            $dates = [];
            $currentDate = new DateTime($startDate);
            $yesterday = new DateTime('yesterday');
            
            while ($currentDate <= $yesterday) {
                $dates[] = $currentDate->format('Y-m-d');
                $currentDate->modify('+1 day');
            }
            
            $headers = ['SNo', 'BUNK ID', 'RO Name', 'Sales Area', 'Total QR Count'];
            foreach ($dates as $date) {
                $headers[] = date('d-M-y', strtotime($date));
            }
            
            $col = 'A';
            foreach ($headers as $header) {
                $dailySheet->setCellValue($col . '1', $header);
                $col++;
            }
            
            $lastCol = chr(ord('A') + count($headers) - 1);
            if (count($headers) > 26) {
                $lastCol = 'A' . chr(ord('A') + count($headers) - 27);
            }
            
            $dailySheet->getStyle('A1:' . $lastCol . '1')->applyFromArray($headerStyle);
            $dailySheet->freezePane('A2');
            
            $roQuery = $pdo->prepare("
                SELECT r.bunkid, r.roname, r.salesarea, COUNT(q.id) AS total_qr_count
                FROM Hpcl_Odisha_rolist2025 r
                LEFT JOIN Hpcl_Odisha_QRForm2025 q ON r.bunkid = q.bunkid AND q.id > 22 AND DATE(q.date_time) < CURDATE()
                WHERE 1=1 $regionCondition
                GROUP BY r.bunkid, r.roname, r.salesarea
                ORDER BY r.salesarea, r.roname
            ");
            $roQuery->execute($regionParam);
            $roData = $roQuery->fetchAll(PDO::FETCH_ASSOC);
            
            $row = 2;
            $sno = 1;
            
            foreach ($roData as $ro) {
                $dailyCountsQuery = $pdo->prepare("
                    SELECT DATE(date_time) AS date, COUNT(*) AS qr_count
                    FROM Hpcl_Odisha_QRForm2025
                    WHERE bunkid = :bunkid AND id > 22 AND DATE(date_time) < CURDATE()
                    GROUP BY DATE(date_time)
                    ORDER BY date
                ");
                $dailyCountsQuery->execute([':bunkid' => $ro['bunkid']]);
                $dailyCounts = $dailyCountsQuery->fetchAll(PDO::FETCH_KEY_PAIR);
                
                $dailySheet->setCellValue('A' . $row, $sno);
                $dailySheet->setCellValue('B' . $row, $ro['bunkid']);
                $dailySheet->setCellValue('C' . $row, $ro['roname']);
                $dailySheet->setCellValue('D' . $row, $ro['salesarea']);
                $dailySheet->setCellValue('E' . $row, $ro['total_qr_count']);
                
                $colIndex = 5;
                foreach ($dates as $date) {
                    $colLetter = chr(ord('A') + $colIndex);
                    if ($colIndex > 25) {
                        $colLetter = 'A' . chr(ord('A') + $colIndex - 26);
                    }
                    $count = isset($dailyCounts[$date]) ? $dailyCounts[$date] : 0;
                    $dailySheet->setCellValue($colLetter . $row, $count);
                    $colIndex++;
                }
                
                $row++;
                $sno++;
            }
            
            $totalRow = $row;
            $dailySheet->setCellValue('A' . $totalRow, 'TOTAL');
            $dailySheet->mergeCells('A' . $totalRow . ':D' . $totalRow);
            $dailySheet->getStyle('A' . $totalRow . ':D' . $totalRow)->getAlignment()->setHorizontal(Alignment::HORIZONTAL_RIGHT);
            
            $columnTotals = array_fill(0, count($headers), 0);
            foreach ($roData as $ro) {
                $columnTotals[4] += $ro['total_qr_count'];
                
                $dailyCountsQuery = $pdo->prepare("
                    SELECT DATE(date_time) AS date, COUNT(*) AS qr_count
                    FROM Hpcl_Odisha_QRForm2025
                    WHERE bunkid = :bunkid AND id > 22 AND DATE(date_time) < CURDATE()
                    GROUP BY DATE(date_time)
                    ORDER BY date
                ");
                $dailyCountsQuery->execute([':bunkid' => $ro['bunkid']]);
                $dailyCounts = $dailyCountsQuery->fetchAll(PDO::FETCH_KEY_PAIR);
                
                $colIndex = 5;
                foreach ($dates as $date) {
                    $count = isset($dailyCounts[$date]) ? $dailyCounts[$date] : 0;
                    $columnTotals[$colIndex] += $count;
                    $colIndex++;
                }
            }
            
            $dailySheet->setCellValue('E' . $totalRow, $columnTotals[4]);
            $colIndex = 5;
            foreach ($dates as $date) {
                $colLetter = chr(ord('A') + $colIndex);
                if ($colIndex > 25) {
                    $colLetter = 'A' . chr(ord('A') + $colIndex - 26);
                }
                $dailySheet->setCellValue($colLetter . $totalRow, $columnTotals[$colIndex]);
                $colIndex++;
            }
            
            $dailySheet->getStyle('A' . $totalRow . ':' . $lastCol . $totalRow)->applyFromArray([
                'font' => ['bold' => true],
                'fill' => [
                    'fillType' => Fill::FILL_SOLID,
                    'startColor' => ['rgb' => 'D9E1F2']
                ],
                'borders' => [
                    'top' => [
                        'borderStyle' => Border::BORDER_MEDIUM,
                        'color' => ['rgb' => '000000']
                    ]
                ]
            ]);
            
            $dailySheet->getStyle('A2:' . $lastCol . ($row-1))->applyFromArray($dataStyle);
            for ($i = 2; $i < $row; $i += 2) {
                $dailySheet->getStyle('A' . $i . ':' . $lastCol . $i)->applyFromArray($highlightStyle);
            }
            
            $dailySheet->getColumnDimension('A')->setWidth(8);
            $dailySheet->getColumnDimension('B')->setWidth(12);
            $dailySheet->getColumnDimension('C')->setWidth(30);
            $dailySheet->getColumnDimension('D')->setWidth(25);
            $dailySheet->getColumnDimension('E')->setWidth(18);
            
            for ($i = 5; $i < count($headers); $i++) {
                $colLetter = chr(ord('A') + $i);
                if ($i > 25) {
                    $colLetter = 'A' . chr(ord('A') + $i - 26);
                }
                $dailySheet->getColumnDimension($colLetter)->setWidth(12);
            }
        }
    } catch (Exception $e) {
        $dailySheet->setCellValue('A1', 'Error creating QR sheet: ' . $e->getMessage());
        $dailySheet->getStyle('A1')->applyFromArray($titleStyle);
    }

    $dailySMSSheet = $spreadsheet->createSheet();
    $dailySMSSheet->setTitle('Daily SMS Entries');
    
    try {
        $smsDateQuery = $pdo->prepare("
            SELECT DATE(MIN(s.date_time)) AS min_date 
            FROM Hpcl_Odisha_SMSdata2025 s
            JOIN Hpcl_Odisha_rolist2025 r ON s.bunk_id = r.bunkid
            WHERE 1=1 $regionCondition
        ");
        $smsDateQuery->execute($regionParam);
        $smsStartDate = $smsDateQuery->fetchColumn();
        
        if (!$smsStartDate) {
            $dailySMSSheet->setCellValue('A1', 'No SMS data available');
            $dailySMSSheet->getStyle('A1')->applyFromArray($titleStyle);
        } else {
            $smsDates = [];
            $currentDate = new DateTime($smsStartDate);
            $yesterday = new DateTime('yesterday');
            
            while ($currentDate <= $yesterday) {
                $smsDates[] = $currentDate->format('Y-m-d');
                $currentDate->modify('+1 day');
            }
            
            $smsHeaders = ['SNo', 'BUNK ID', 'RO Name', 'Sales Area', 'Total SMS Count'];
            foreach ($smsDates as $date) {
                $smsHeaders[] = date('d-M-y', strtotime($date));
            }
            
            $col = 'A';
            foreach ($smsHeaders as $header) {
                $dailySMSSheet->setCellValue($col . '1', $header);
                $col++;
            }
            
            $smsLastCol = chr(ord('A') + count($smsHeaders) - 1);
            if (count($smsHeaders) > 26) {
                $smsLastCol = 'A' . chr(ord('A') + count($smsHeaders) - 27);
            }
            
            $dailySMSSheet->getStyle('A1:' . $smsLastCol . '1')->applyFromArray($headerStyle);
            $dailySMSSheet->freezePane('A2');
            
            $smsRoQuery = $pdo->prepare("
                SELECT r.bunkid, r.roname, r.salesarea, COUNT(s.id) AS total_sms_count
                FROM Hpcl_Odisha_rolist2025 r
                LEFT JOIN Hpcl_Odisha_SMSdata2025 s ON r.bunkid = s.bunk_id AND DATE(s.date_time) < CURDATE()
                WHERE 1=1 $regionCondition
                GROUP BY r.bunkid, r.roname, r.salesarea
                ORDER BY r.salesarea, r.roname
            ");
            $smsRoQuery->execute($regionParam);
            $smsRoData = $smsRoQuery->fetchAll(PDO::FETCH_ASSOC);
            
            $smsRow = 2;
            $smsSno = 1;
            
            foreach ($smsRoData as $ro) {
                $dailySMSCountsQuery = $pdo->prepare("
                    SELECT DATE(date_time) AS date, COUNT(*) AS sms_count
                    FROM Hpcl_Odisha_SMSdata2025
                    WHERE bunk_id = :bunkid AND DATE(date_time) < CURDATE()
                    GROUP BY DATE(date_time)
                    ORDER BY date
                ");
                $dailySMSCountsQuery->execute([':bunkid' => $ro['bunkid']]);
                $dailySMSCounts = $dailySMSCountsQuery->fetchAll(PDO::FETCH_KEY_PAIR);
                
                $dailySMSSheet->setCellValue('A' . $smsRow, $smsSno);
                $dailySMSSheet->setCellValue('B' . $smsRow, $ro['bunkid']);
                $dailySMSSheet->setCellValue('C' . $smsRow, $ro['roname']);
                $dailySMSSheet->setCellValue('D' . $smsRow, $ro['salesarea']);
                $dailySMSSheet->setCellValue('E' . $smsRow, $ro['total_sms_count']);
                
                $colIndex = 5;
                foreach ($smsDates as $date) {
                    $colLetter = chr(ord('A') + $colIndex);
                    if ($colIndex > 25) {
                        $colLetter = 'A' . chr(ord('A') + $colIndex - 26);
                    }
                    $count = isset($dailySMSCounts[$date]) ? $dailySMSCounts[$date] : 0;
                    $dailySMSSheet->setCellValue($colLetter . $smsRow, $count);
                    $colIndex++;
                }
                
                $smsRow++;
                $smsSno++;
            }
            
            $totalSMSRow = $smsRow;
            $dailySMSSheet->setCellValue('A' . $totalSMSRow, 'TOTAL');
            $dailySMSSheet->mergeCells('A' . $totalSMSRow . ':D' . $totalSMSRow);
            $dailySMSSheet->getStyle('A' . $totalSMSRow . ':D' . $totalSMSRow)->getAlignment()->setHorizontal(Alignment::HORIZONTAL_RIGHT);
            
            $smsColumnTotals = array_fill(0, count($smsHeaders), 0);
            foreach ($smsRoData as $ro) {
                $smsColumnTotals[4] += $ro['total_sms_count'];
                
                $dailySMSCountsQuery = $pdo->prepare("
                    SELECT DATE(date_time) AS date, COUNT(*) AS sms_count
                    FROM Hpcl_Odisha_SMSdata2025
                    WHERE bunk_id = :bunkid AND DATE(date_time) < CURDATE()
                    GROUP BY DATE(date_time)
                    ORDER BY date
                ");
                $dailySMSCountsQuery->execute([':bunkid' => $ro['bunkid']]);
                $dailySMSCounts = $dailySMSCountsQuery->fetchAll(PDO::FETCH_KEY_PAIR);
                
                $colIndex = 5;
                foreach ($smsDates as $date) {
                    $count = isset($dailySMSCounts[$date]) ? $dailySMSCounts[$date] : 0;
                    $smsColumnTotals[$colIndex] += $count;
                    $colIndex++;
                }
            }
            
            $dailySMSSheet->setCellValue('E' . $totalSMSRow, $smsColumnTotals[4]);
            $colIndex = 5;
            foreach ($smsDates as $date) {
                $colLetter = chr(ord('A') + $colIndex);
                if ($colIndex > 25) {
                    $colLetter = 'A' . chr(ord('A') + $colIndex - 26);
                }
                $dailySMSSheet->setCellValue($colLetter . $totalSMSRow, $smsColumnTotals[$colIndex]);
                $colIndex++;
            }
            
            $dailySMSSheet->getStyle('A' . $totalSMSRow . ':' . $smsLastCol . $totalSMSRow)->applyFromArray([
                'font' => ['bold' => true],
                'fill' => [
                    'fillType' => Fill::FILL_SOLID,
                    'startColor' => ['rgb' => 'D9E1F2']
                ],
                'borders' => [
                    'top' => [
                        'borderStyle' => Border::BORDER_MEDIUM,
                        'color' => ['rgb' => '000000']
                    ]
                ]
            ]);
            
            $dailySMSSheet->getStyle('A2:' . $smsLastCol . ($smsRow-1))->applyFromArray($dataStyle);
            for ($i = 2; $i < $smsRow; $i += 2) {
                $dailySMSSheet->getStyle('A' . $i . ':' . $smsLastCol . $i)->applyFromArray($highlightStyle);
            }
            
            $dailySMSSheet->getColumnDimension('A')->setWidth(8);
            $dailySMSSheet->getColumnDimension('B')->setWidth(12);
            $dailySMSSheet->getColumnDimension('C')->setWidth(30);
            $dailySMSSheet->getColumnDimension('D')->setWidth(25);
            $dailySMSSheet->getColumnDimension('E')->setWidth(18);
            
            for ($i = 5; $i < count($smsHeaders); $i++) {
                $colLetter = chr(ord('A') + $i);
                if ($i > 25) {
                    $colLetter = 'A' . chr(ord('A') + $i - 26);
                }
                $dailySMSSheet->getColumnDimension($colLetter)->setWidth(12);
            }
        }
    } catch (Exception $e) {
        $dailySMSSheet->setCellValue('A1', 'Error creating SMS sheet: ' . $e->getMessage());
        $dailySMSSheet->getStyle('A1')->applyFromArray($titleStyle);
    }

    $cumulativeSheet = $spreadsheet->createSheet();
    $cumulativeSheet->setTitle('Cumulative QR & SMS Entries');
    
    $titleText = 'Cumulative QR & SMS Entries by RO';
    if ($regionFilter) {
        $titleText .= ' - Region: ' . $regionFilter;
    }
    $cumulativeSheet->setCellValue('A1', $titleText);
    $cumulativeSheet->mergeCells('A1:G1');
    $cumulativeSheet->getStyle('A1')->applyFromArray($titleStyle);
    
    $cumulativeHeaders = ['SNo', 'BUNK ID', 'RO Name', 'Sales Area', 'QR+SMS Total', 'QR Total', 'SMS Total'];
    $col = 'A';
    foreach ($cumulativeHeaders as $header) {
        $cumulativeSheet->setCellValue($col . '3', $header);
        $col++;
    }
    $cumulativeSheet->getStyle('A3:G3')->applyFromArray($headerStyle);
    
    $cumulativeQuery = $pdo->prepare("
        SELECT 
            r.bunkid, r.roname, r.salesarea,
            COALESCE(q.qr_count, 0) AS qr_count,
            COALESCE(s.sms_count, 0) AS sms_count,
            COALESCE(q.qr_count, 0) + COALESCE(s.sms_count, 0) AS total_entries
        FROM Hpcl_Odisha_rolist2025 r
        LEFT JOIN (
            SELECT bunkid, COUNT(*) AS qr_count 
            FROM Hpcl_Odisha_QRForm2025 
            WHERE DATE(date_time) < CURDATE() AND id > 22
            GROUP BY bunkid
        ) q ON r.bunkid = q.bunkid
        LEFT JOIN (
            SELECT bunk_id, COUNT(*) AS sms_count 
            FROM Hpcl_Odisha_SMSdata2025 
            WHERE DATE(date_time) < CURDATE()
            GROUP BY bunk_id
        ) s ON r.bunkid = s.bunk_id
        WHERE 1=1 $regionCondition
        ORDER BY total_entries DESC, r.salesarea, r.roname
    ");
    $cumulativeQuery->execute($regionParam);
    $cumulativeData = $cumulativeQuery->fetchAll(PDO::FETCH_ASSOC);
    
    $row = 4;
    $sno = 1;
    $totalQRSMS = 0;
    $totalQR = 0;
    $totalSMS = 0;
    
    foreach ($cumulativeData as $ro) {
        $cumulativeSheet->setCellValue('A' . $row, $sno);
        $cumulativeSheet->setCellValue('B' . $row, $ro['bunkid']);
        $cumulativeSheet->setCellValue('C' . $row, $ro['roname']);
        $cumulativeSheet->setCellValue('D' . $row, $ro['salesarea']);
        $cumulativeSheet->setCellValue('E' . $row, $ro['total_entries']);
        $cumulativeSheet->setCellValue('F' . $row, $ro['qr_count']);
        $cumulativeSheet->setCellValue('G' . $row, $ro['sms_count']);
        
        $totalQRSMS += $ro['total_entries'];
        $totalQR += $ro['qr_count'];
        $totalSMS += $ro['sms_count'];
        
        $row++;
        $sno++;
    }
    
    $cumulativeSheet->setCellValue('A' . $row, 'TOTAL');
    $cumulativeSheet->mergeCells('A' . $row . ':D' . $row);
    $cumulativeSheet->getStyle('A' . $row . ':D' . $row)->getAlignment()->setHorizontal(Alignment::HORIZONTAL_RIGHT);
    $cumulativeSheet->setCellValue('E' . $row, $totalQRSMS);
    $cumulativeSheet->setCellValue('F' . $row, $totalQR);
    $cumulativeSheet->setCellValue('G' . $row, $totalSMS);
    
    $cumulativeSheet->getStyle('A' . $row . ':G' . $row)->applyFromArray([
        'font' => ['bold' => true],
        'fill' => [
            'fillType' => Fill::FILL_SOLID,
            'startColor' => ['rgb' => 'D9E1F2']
        ],
        'borders' => [
            'top' => [
                'borderStyle' => Border::BORDER_MEDIUM,
                'color' => ['rgb' => '000000']
            ]
        ]
    ]);
    
    $cumulativeSheet->getStyle('A4:G' . ($row-1))->applyFromArray($dataStyle);
    for ($i = 4; $i < $row; $i += 2) {
        $cumulativeSheet->getStyle('A' . $i . ':G' . $i)->applyFromArray($highlightStyle);
    }
    
    $cumulativeSheet->getColumnDimension('A')->setWidth(8);
    $cumulativeSheet->getColumnDimension('B')->setWidth(12);
    $cumulativeSheet->getColumnDimension('C')->setWidth(35);
    $cumulativeSheet->getColumnDimension('D')->setWidth(25);
    $cumulativeSheet->getColumnDimension('E')->setWidth(18);
    $cumulativeSheet->getColumnDimension('F')->setWidth(15);
    $cumulativeSheet->getColumnDimension('G')->setWidth(15);

    $qrRawSheet = $spreadsheet->createSheet();
    $qrRawSheet->setTitle('QR RawData');
    
    $titleText = 'QR Form Raw Data (Excluding First 22 Test Entries)';
    if ($regionFilter) {
        $titleText .= ' - Region: ' . $regionFilter;
    }
    $qrRawSheet->setCellValue('A1', $titleText);
    $qrRawSheet->mergeCells('A1:J1');
    $qrRawSheet->getStyle('A1')->applyFromArray($titleStyle);
    
    $qrHeaders = ['SNo', 'BUNKID', 'Full Name', 'Mobile', 'Bill Amount', 'Date/Time', 'Coupon Code', 'Vehicle Type', 'RO Name', 'Sales Area'];
    $col = 'A';
    foreach ($qrHeaders as $header) {
        $qrRawSheet->setCellValue($col . '3', $header);
        $col++;
    }
    $qrRawSheet->getStyle('A3:J3')->applyFromArray($headerStyle);
    
    $qrRawQuery = $pdo->prepare("
        SELECT q.id, q.bunkid, q.fullname, q.mobile, q.vehicle_number, q.date_time, q.coupon_code_text, q.vehicle_type, r.roname, r.salesarea
        FROM Hpcl_Odisha_QRForm2025 q
        JOIN Hpcl_Odisha_rolist2025 r ON q.bunkid = r.bunkid
        WHERE q.id > 22 AND DATE(q.date_time) < CURDATE() $regionCondition
        ORDER BY q.date_time ASC
    ");
    $qrRawQuery->execute($regionParam);
    $qrRawData = $qrRawQuery->fetchAll(PDO::FETCH_ASSOC);
    
    $row = 4;
    $sno = 1;
    
    foreach ($qrRawData as $entry) {
        $qrRawSheet->setCellValue('A' . $row, $sno);
        $qrRawSheet->setCellValue('B' . $row, $entry['bunkid']);
        $qrRawSheet->setCellValue('C' . $row, $entry['fullname']);
        $qrRawSheet->setCellValue('D' . $row, $entry['mobile']);
        $qrRawSheet->setCellValue('E' . $row, $entry['vehicle_number']);
        $qrRawSheet->setCellValue('F' . $row, $entry['date_time']);
        $qrRawSheet->setCellValue('G' . $row, $entry['coupon_code_text']);
        $qrRawSheet->setCellValue('H' . $row, $entry['vehicle_type']);
        $qrRawSheet->setCellValue('I' . $row, $entry['roname']);
        $qrRawSheet->setCellValue('J' . $row, $entry['salesarea']);
        $row++;
        $sno++;
    }
    
    $qrRawSheet->getStyle('A4:J' . ($row-1))->applyFromArray($dataStyle);
    for ($i = 4; $i < $row; $i += 2) {
        $qrRawSheet->getStyle('A' . $i . ':J' . $i)->applyFromArray($highlightStyle);
    }
    
    $qrRawSheet->getColumnDimension('A')->setWidth(8);
    $qrRawSheet->getColumnDimension('B')->setWidth(12);
    $qrRawSheet->getColumnDimension('C')->setWidth(35);
    $qrRawSheet->getColumnDimension('D')->setWidth(18);
    $qrRawSheet->getColumnDimension('E')->setWidth(15);
    $qrRawSheet->getColumnDimension('F')->setWidth(22);
    $qrRawSheet->getColumnDimension('G')->setWidth(25);
    $qrRawSheet->getColumnDimension('H')->setWidth(18);
    $qrRawSheet->getColumnDimension('I')->setWidth(35);
    $qrRawSheet->getColumnDimension('J')->setWidth(25);
    
    $qrRawSheet->getStyle('F4:F' . ($row-1))->getNumberFormat()->setFormatCode('dd-mmm-yyyy hh:mm:ss');
    $qrRawSheet->freezePane('A4');

    $smsRawSheet = $spreadsheet->createSheet();
    $smsRawSheet->setTitle('SMS RawData');
    
    $titleText = 'SMS Form Raw Data';
    if ($regionFilter) {
        $titleText .= ' - Region: ' . $regionFilter;
    }
    $smsRawSheet->setCellValue('A1', $titleText);
    $smsRawSheet->mergeCells('A1:I1');
    $smsRawSheet->getStyle('A1')->applyFromArray($titleStyle);
    
    $smsHeaders = ['SNo', 'Number', 'Message', 'Keyword', 'Transaction ID', 'BUNKID', 'Date/Time', 'RO Name', 'Sales Area'];
    $col = 'A';
    foreach ($smsHeaders as $header) {
        $smsRawSheet->setCellValue($col . '3', $header);
        $col++;
    }
    $smsRawSheet->getStyle('A3:I3')->applyFromArray($headerStyle);
    
    $smsRawQuery = $pdo->prepare("
        SELECT s.number, s.message, s.keyword, s.transaction_id, s.bunk_id, s.date_time, r.roname, r.salesarea
        FROM Hpcl_Odisha_SMSdata2025 s
        JOIN Hpcl_Odisha_rolist2025 r ON s.bunk_id = r.bunkid
        WHERE DATE(s.date_time) < CURDATE() $regionCondition
        ORDER BY s.date_time ASC
    ");
    $smsRawQuery->execute($regionParam);
    $smsRawData = $smsRawQuery->fetchAll(PDO::FETCH_ASSOC);
    
    $row = 4;
    $sno = 1;
    
    foreach ($smsRawData as $entry) {
        $smsRawSheet->setCellValue('A' . $row, $sno);
        $smsRawSheet->setCellValue('B' . $row, $entry['number']);
        $smsRawSheet->setCellValue('C' . $row, $entry['message']);
        $smsRawSheet->setCellValue('D' . $row, $entry['keyword']);
        $smsRawSheet->setCellValue('E' . $row, $entry['transaction_id']);
        $smsRawSheet->setCellValue('F' . $row, $entry['bunk_id']);
        $smsRawSheet->setCellValue('G' . $row, $entry['date_time']);
        $smsRawSheet->setCellValue('H' . $row, $entry['roname']);
        $smsRawSheet->setCellValue('I' . $row, $entry['salesarea']);
        $row++;
        $sno++;
    }
    
    $smsRawSheet->getStyle('A4:I' . ($row-1))->applyFromArray($dataStyle);
    for ($i = 4; $i < $row; $i += 2) {
        $smsRawSheet->getStyle('A' . $i . ':I' . $i)->applyFromArray($highlightStyle);
    }
    
    $smsRawSheet->getColumnDimension('A')->setWidth(8);
    $smsRawSheet->getColumnDimension('B')->setWidth(18);
    $smsRawSheet->getColumnDimension('C')->setWidth(50);
    $smsRawSheet->getColumnDimension('D')->setWidth(18);
    $smsRawSheet->getColumnDimension('E')->setWidth(25);
    $smsRawSheet->getColumnDimension('F')->setWidth(12);
    $smsRawSheet->getColumnDimension('G')->setWidth(22);
    $smsRawSheet->getColumnDimension('H')->setWidth(35);
    $smsRawSheet->getColumnDimension('I')->setWidth(25);
    
    $smsRawSheet->getStyle('G4:G' . ($row-1))->getNumberFormat()->setFormatCode('dd-mmm-yyyy hh:mm:ss');
    $smsRawSheet->freezePane('A4');

    $spreadsheet->setActiveSheetIndex(0);
    
    $filename = 'IOCL_Warangal_Campaign_Report_';
    if ($regionFilter) {
        $filename .= $regionFilter . '_';
    }
    $filename .= date('Y-m-d_H-i-s') . '.xlsx';
    
    header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
    header('Content-Disposition: attachment;filename="' . $filename . '"');
    header('Cache-Control: max-age=0');
    
    $writer = new Xlsx($spreadsheet);
    $writer->save('php://output');
    exit;
}

$dashboardData = getDashboardData($pdo, $regionFilter);
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>IOCL Warangal Campaign Dashboard<?php echo $regionFilter ? ' - ' . htmlspecialchars($regionFilter) : ''; ?></title>
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <style>
        :root {
            /* HPCL Color Scheme */
            --primary: #003366; /* Dark Blue */
            --secondary: #002244; /* Darker Blue */
            --accent: #DC143C; /* Red */
            --light: #FFFFFF; /* White */
            --dark: #1a1a1a;
            --success: #28a745;
            --danger: #DC143C; /* Red */
            --warning: #ffc107;
            --info: #17a2b8;
            --gray: #6c757d;
            --light-gray: #f8f9fa;
            --hpcl-red: #DC143C;
            --hpcl-dark-blue: #003366;
            --hpcl-light-blue: #0056a6;
        }
        
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        body {
            font-family: 'Inter', -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, Oxygen, Ubuntu, Cantarell, sans-serif;
            background-color: #f5f7fa;
            color: var(--dark);
            line-height: 1.6;
        }
        
        .dashboard-container {
            max-width: 1800px;
            margin: 0 auto;
            padding: 20px;
        }
        
        .dashboard-header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 30px;
            padding-bottom: 20px;
            border-bottom: 3px solid var(--hpcl-red);
            background: white;
            padding: 30px;
            border-radius: 12px;
            box-shadow: 0 4px 6px rgba(0,0,0,0.05);
        }
        
        .header-title h1 {
            font-size: 2rem;
            font-weight: 700;
            color: var(--hpcl-dark-blue);
            margin-bottom: 5px;
        }
        
        .header-title p {
            color: var(--gray);
            font-size: 0.9rem;
        }
        
        .region-badge {
            background: var(--hpcl-red);
            color: white;
            padding: 4px 12px;
            border-radius: 20px;
            font-size: 0.85rem;
            margin-left: 10px;
            display: inline-block;
        }
        
        .export-btn {
            background: var(--hpcl-red);
            color: white;
            padding: 12px 24px;
            border: none;
            border-radius: 8px;
            font-size: 1rem;
            cursor: pointer;
            text-decoration: none;
            display: inline-flex;
            align-items: center;
            gap: 8px;
            transition: all 0.3s ease;
            box-shadow: 0 4px 6px rgba(220, 20, 60, 0.2);
        }
        
        .export-btn:hover {
            background: #B91C3C;
            transform: translateY(-2px);
            box-shadow: 0 6px 12px rgba(220, 20, 60, 0.3);
        }
        
        .stats-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(240px, 1fr));
            gap: 20px;
            margin-bottom: 30px;
        }
        
        .stat-card {
            background: white;
            border-radius: 12px;
            padding: 25px;
            box-shadow: 0 4px 6px rgba(0,0,0,0.05);
            transition: all 0.3s ease;
            border-top: 4px solid var(--hpcl-dark-blue);
        }
        
        .stat-card:hover {
            transform: translateY(-5px);
            box-shadow: 0 10px 20px rgba(0,0,0,0.1);
            border-top-color: var(--hpcl-red);
        }
        
        .stat-card .stat-value {
            font-size: 2.2rem;
            font-weight: 700;
            color: var(--hpcl-dark-blue);
            margin-bottom: 5px;
            display: flex;
            align-items: center;
            gap: 10px;
        }
        
        .stat-card .stat-value i {
            color: var(--hpcl-red);
        }
        
        .stat-card .stat-label {
            font-size: 0.9rem;
            color: var(--gray);
            text-transform: uppercase;
            letter-spacing: 0.5px;
            margin-bottom: 10px;
        }
        
        .stat-card .stat-meta {
            display: flex;
            gap: 15px;
            font-size: 0.85rem;
        }
        
        .stat-meta .meta-item {
            display: flex;
            align-items: center;
            gap: 5px;
        }
        
        .meta-item.active {
            color: var(--success);
        }
        
        .meta-item.inactive {
            color: var(--hpcl-red);
        }
        
        .main-content {
            display: flex;
            flex-direction: column;
            gap: 25px;
            margin-bottom: 30px;
        }
        
        .card {
            background: white;
            border-radius: 12px;
            padding: 25px;
            box-shadow: 0 4px 6px rgba(0,0,0,0.05);
        }
        
        .card-header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 20px;
            padding-bottom: 15px;
            border-bottom: 2px solid var(--light-gray);
        }
        
        .card-title {
            font-size: 1.2rem;
            font-weight: 600;
            color: var(--hpcl-dark-blue);
        }
        
        .card-title i {
            margin-right: 10px;
            color: var(--hpcl-red);
        }
        
        .chart-container {
            width: 100%;
            height: 300px;
            margin-top: 20px;
        }
        
        .area-grid {
            display: grid;
            grid-template-columns: repeat(auto-fill, minmax(220px, 1fr));
            gap: 15px;
            margin-top: 20px;
        }
        
        .area-card {
            background: white;
            border-radius: 10px;
            padding: 15px;
            box-shadow: 0 2px 4px rgba(0,0,0,0.05);
            transition: all 0.3s ease;
            border-left: 4px solid var(--hpcl-red);
        }
        
        .area-card:hover {
            transform: translateY(-3px);
            box-shadow: 0 5px 15px rgba(0,0,0,0.1);
            border-left-color: var(--hpcl-dark-blue);
        }
        
        .area-card .area-value {
            font-size: 1.5rem;
            font-weight: 700;
            color: var(--hpcl-dark-blue);
            margin-bottom: 5px;
        }
        
        .area-card .area-label {
            font-size: 0.9rem;
            color: var(--gray);
            margin-bottom: 8px;
        }
        
        .area-card .area-meta {
            font-size: 0.8rem;
            color: #adb5bd;
        }
        
        .daily-stats {
            display: flex;
            gap: 15px;
            overflow-x: auto;
            padding: 15px 5px;
            margin-bottom: 20px;
        }
        
        .daily-item {
            background: white;
            padding: 15px;
            border-radius: 10px;
            min-width: 150px;
            text-align: center;
            flex-shrink: 0;
            box-shadow: 0 2px 4px rgba(0,0,0,0.05);
            border-bottom: 3px solid var(--hpcl-red);
        }
        
        .daily-item .day {
            font-weight: 600;
            color: var(--hpcl-dark-blue);
            margin-bottom: 5px;
        }
        
        .daily-item .total {
            font-size: 1.2rem;
            font-weight: 700;
            color: var(--hpcl-red);
            margin-bottom: 5px;
        }
        
        .daily-item .breakdown {
            font-size: 0.8rem;
            color: var(--gray);
        }
        
        .table-responsive {
            overflow-x: auto;
            width: 100%;
        }
        
        table {
            width: 100%;
            border-collapse: separate;
            border-spacing: 0;
            min-width: 800px;
        }
        
        th {
            background-color: var(--hpcl-dark-blue);
            color: white;
            font-weight: 600;
            padding: 12px 15px;
            text-align: left;
            position: sticky;
            top: 0;
        }
        
        td {
            padding: 12px 15px;
            border-bottom: 1px solid var(--light-gray);
            vertical-align: middle;
        }
        
        tr:hover td {
            background-color: rgba(0, 51, 102, 0.05);
        }
        
        .badge {
            display: inline-block;
            padding: 4px 8px;
            border-radius: 20px;
            font-size: 0.75rem;
            font-weight: 600;
        }
        
        .badge-primary {
            background-color: rgba(0, 51, 102, 0.1);
            color: var(--hpcl-dark-blue);
        }
        
        .badge-success {
            background-color: rgba(40, 167, 69, 0.1);
            color: var(--success);
        }
        
        .badge-danger {
            background-color: rgba(220, 20, 60, 0.1);
            color: var(--hpcl-red);
        }
        
        .filter-control {
            margin-bottom: 20px;
        }
        
        .filter-control label {
            font-weight: 600;
            margin-right: 10px;
            color: var(--hpcl-dark-blue);
        }
        
        .filter-control select {
            padding: 8px 12px;
            border-radius: 6px;
            border: 2px solid var(--hpcl-dark-blue);
            background: white;
            font-size: 0.9rem;
            color: var(--hpcl-dark-blue);
        }
        
        .filter-control select:focus {
            outline: none;
            border-color: var(--hpcl-red);
        }
        
        @media (max-width: 768px) {
            .dashboard-header {
                flex-direction: column;
                align-items: flex-start;
                gap: 15px;
            }
            
            .stats-grid {
                grid-template-columns: 1fr 1fr;
            }
            
            .area-grid {
                grid-template-columns: 1fr 1fr;
            }
        }
        
        @media (max-width: 576px) {
            .stats-grid {
                grid-template-columns: 1fr;
            }
            
            .area-grid {
                grid-template-columns: 1fr;
            }
        }
    </style>
</head>
<body>
<div class="dashboard-container">
    <header class="dashboard-header">
        <div class="header-title">
            <h1>
                IOCL Warangal Campaign Dashboard
                <?php if ($regionFilter): ?>
                    <span class="region-badge">Region: <?php echo htmlspecialchars($regionFilter); ?></span>
                <?php endif; ?>
            </h1>
            <p>Participation analytics for the current campaign (data up to yesterday)</p>
        </div>
        <a href="?export=excel<?php echo $regionFilter ? '&region=' . urlencode($regionFilter) : ''; ?>" class="export-btn">
            <i class="fas fa-file-excel"></i> Export Report
        </a>
    </header>

    <div class="stats-grid">
        <div class="stat-card">
            <div class="stat-value">
                <i class="fas fa-chart-line"></i>
                <?php echo number_format($dashboardData['total_entries']); ?>
            </div>
            <div class="stat-label">Total Entries</div>
            <div class="stat-meta">
                <span class="meta-item">
                    <i class="fas fa-qrcode"></i> QR: <?php echo number_format($dashboardData['qr_entries']); ?>
                </span>
                <span class="meta-item">
                    <i class="fas fa-sms"></i> SMS: <?php echo number_format($dashboardData['sms_entries']); ?>
                </span>
            </div>
        </div>
        
        <div class="stat-card">
            <div class="stat-value">
                <i class="fas fa-users"></i>
                <?php echo number_format($dashboardData['unique_participants']); ?>
            </div>
            <div class="stat-label">Unique Participants</div>
            <div class="stat-meta">
                <span class="meta-item">
                    <i class="fas fa-mobile-alt"></i> Mobile entries
                </span>
            </div>
        </div>
        
        <div class="stat-card">
            <div class="stat-value">
                <i class="fas fa-gas-pump"></i>
                <?php echo number_format($dashboardData['active_ros'] + $dashboardData['inactive_ros']); ?>
            </div>
            <div class="stat-label">Total Retail Outlets</div>
            <div class="stat-meta">
                <span class="meta-item active">
                    <i class="fas fa-check-circle"></i> Active: <?php echo $dashboardData['active_ros']; ?>
                </span>
                <span class="meta-item inactive">
                    <i class="fas fa-times-circle"></i> Inactive: <?php echo $dashboardData['inactive_ros']; ?>
                </span>
            </div>
        </div>
        
        <div class="stat-card">
            <div class="stat-value">
                <i class="fas fa-map-marked-alt"></i>
                <?php echo count(array_unique(array_column($dashboardData['ro_details'], 'salesarea'))); ?>
            </div>
            <div class="stat-label">Sales Areas</div>
            <div class="stat-meta">
                <span class="meta-item">
                    <i class="fas fa-globe-asia"></i> Regional coverage
                </span>
            </div>
        </div>
    </div>

    <div class="main-content">
        <div class="card">
            <div class="card-header">
                <h3 class="card-title"><i class="fas fa-chart-bar"></i> Daily Participation Trend</h3>
            </div>
            <div class="daily-stats">
                <?php foreach($dashboardData['daily_entries'] as $day): ?>
                    <div class="daily-item">
                        <div class="day"><?php echo date('D, M j', strtotime($day['date'])); ?></div>
                        <div class="total"><?php echo $day['total_count']; ?></div>
                        <div class="breakdown">
                            QR: <?php echo $day['qr_count']; ?> | 
                            SMS: <?php echo $day['sms_count']; ?>
                        </div>
                    </div>
                <?php endforeach; ?>
            </div>
            <div class="chart-container">
                <canvas id="dailyEntriesChart"></canvas>
            </div>
        </div>
        
        <div class="card">
            <div class="card-header">
                <h3 class="card-title"><i class="fas fa-map"></i> Area Performance</h3>
            </div>
            <div class="chart-container" style="height: 400px;">
                <canvas id="areaPerformanceChart"></canvas>
            </div>
            <div class="area-grid">
                <?php foreach($dashboardData['salesarea_summary_combined'] as $area): ?>
                    <div class="area-card">
                        <div class="area-value"><?php echo $area['total_entries']; ?></div>
                        <div class="area-label"><?php echo htmlspecialchars($area['salesarea']); ?></div>
                        <div class="area-meta">
                            QR: <?php echo $area['qr_entries']; ?> | 
                            SMS: <?php echo $area['sms_entries']; ?>
                        </div>
                    </div>
                <?php endforeach; ?>
            </div>
        </div>
        
        <div class="card">
            <div class="card-header">
                <h3 class="card-title"><i class="fas fa-trophy"></i> Top Performing Retail Outlets</h3>
            </div>
            <div class="filter-control">
                <label for="areaFilter">Filter by Area:</label>
                <select id="areaFilter">
                    <option value="">All Areas</option>
                    <?php
                    $areas = array_unique(array_column($dashboardData['ro_details'],'salesarea'));
                    foreach ($areas as $a) {
                        if (!empty($a)) {
                            echo '<option value="'.htmlspecialchars($a).'">'.htmlspecialchars($a).'</option>';
                        }
                    }
                    ?>
                </select>
            </div>
            <div class="table-responsive">
                <table id="roTable">
                    <thead>
                        <tr>
                            <th>ID</th>
                            <th>Outlet</th>
                            <th>Area</th>
                            <th>QR</th>
                            <th>SMS</th>
                            <th>Total</th>
                        </tr>
                    </thead>
                    <tbody></tbody>
                </table>
            </div>
        </div>
        
        <div class="card">
            <div class="card-header">
                <h3 class="card-title"><i class="fas fa-exclamation-triangle"></i> Inactive Outlets</h3>
            </div>
            <div class="filter-control">
                <label for="inAreaFilter">Filter by Area:</label>
                <select id="inAreaFilter">
                    <option value="">All Areas</option>
                    <?php
                    $inAreas = array_unique(array_column($dashboardData['inactive_ros_list'],'salesarea'));
                    foreach ($inAreas as $a) {
                        if (!empty($a)) {
                            echo '<option value="'.htmlspecialchars($a).'">'.htmlspecialchars($a).'</option>';
                        }
                    }
                    ?>
                </select>
            </div>
            <div class="table-responsive">
                <table id="inactiveTable">
                    <thead>
                        <tr>
                            <th>ID</th>
                            <th>Outlet</th>
                            <th>Area</th>
                        </tr>
                    </thead>
                    <tbody></tbody>
                </table>
            </div>
        </div>
    </div>
</div>

<script>
const roData = <?php echo json_encode($dashboardData['ro_details']); ?>;
const areaFilter = document.getElementById('areaFilter');
const roTableBody = document.getElementById('roTable').tBodies[0];

const inData = <?php echo json_encode($dashboardData['inactive_ros_list']); ?>;
const inAreaFilter = document.getElementById('inAreaFilter');
const inTableBody = document.getElementById('inactiveTable').tBodies[0];

function renderTopTable(area='') {
    const filtered = area ? roData.filter(r => r.salesarea === area) : roData;
    const top10 = filtered.sort((a,b) => b.total_entries - a.total_entries).slice(0, 10);
    
    roTableBody.innerHTML = '';
    top10.forEach(r => {
        const row = document.createElement('tr');
        
        row.innerHTML = `
            <td><span class="badge badge-primary">${r.bunkid}</span></td>
            <td>${r.roname}</td>
            <td>${r.salesarea}</td>
            <td><span class="badge badge-success">${r.qr_count}</span></td>
            <td><span class="badge badge-success">${r.sms_count}</span></td>
            <td><span class="badge badge-primary">${r.total_entries}</span></td>
        `;
        
        roTableBody.appendChild(row);
    });
}

function renderInactiveTable(area='') {
    const filtered = area ? inData.filter(r => r.salesarea === area) : inData;
    
    inTableBody.innerHTML = '';
    filtered.forEach(r => {
        const row = document.createElement('tr');
        
        row.innerHTML = `
            <td><span class="badge badge-danger">${r.bunkid}</span></td>
            <td>${r.roname}</td>
            <td>${r.salesarea}</td>
        `;
        
        inTableBody.appendChild(row);
    });
}

areaFilter.addEventListener('change', e => renderTopTable(e.target.value));
inAreaFilter.addEventListener('change', e => renderInactiveTable(e.target.value));

renderTopTable();
renderInactiveTable();

// Daily Entries Chart
const dailyData = <?php echo json_encode($dashboardData['daily_entries']); ?>;
const dates = dailyData.map(day => day.date);
const qrCounts = dailyData.map(day => day.qr_count);
const smsCounts = dailyData.map(day => day.sms_count);
const totalCounts = dailyData.map(day => day.total_count);

const formattedDates = dates.map(date => {
    const d = new Date(date);
    return d.toLocaleDateString('en-US', { weekday: 'short', month: 'short', day: 'numeric' });
});

const ctx = document.getElementById('dailyEntriesChart').getContext('2d');
const dailyEntriesChart = new Chart(ctx, {
    type: 'bar',
    data: {
        labels: formattedDates,
        datasets: [
            {
                label: 'QR Entries',
                data: qrCounts,
                backgroundColor: '#003366',
                borderColor: '#002244',
                borderWidth: 1
            },
            {
                label: 'SMS Entries',
                data: smsCounts,
                backgroundColor: '#DC143C',
                borderColor: '#B91C3C',
                borderWidth: 1
            },
            {
                label: 'Total Entries',
                data: totalCounts,
                backgroundColor: 'rgba(0, 51, 102, 0)',
                borderColor: '#0056a6',
                borderWidth: 3,
                type: 'line',
                fill: false,
                tension: 0.3
            }
        ]
    },
    options: {
        responsive: true,
        maintainAspectRatio: false,
        plugins: {
            legend: {
                position: 'top',
                labels: {
                    boxWidth: 12,
                    padding: 20,
                    usePointStyle: true,
                    pointStyle: 'circle'
                }
            },
            tooltip: {
                callbacks: {
                    afterLabel: function(context) {
                        const data = dailyData[context.dataIndex];
                        return `QR: ${data.qr_count}\nSMS: ${data.sms_count}\nTotal: ${data.total_count}`;
                    }
                }
            }
        },
        scales: {
            y: {
                beginAtZero: true,
                grid: {
                    drawBorder: false
                }
            },
            x: {
                grid: {
                    display: false
                }
            }
        },
        elements: {
            bar: {
                borderRadius: 4
            }
        }
    }
});

// Area Performance Chart
const areaData = <?php echo json_encode($dashboardData['salesarea_summary_combined']); ?>;
const areaLabels = areaData.map(area => area.salesarea);
const areaTotals = areaData.map(area => area.total_entries);
const areaQR = areaData.map(area => area.qr_entries);
const areaSMS = areaData.map(area => area.sms_entries);

const areaCtx = document.getElementById('areaPerformanceChart').getContext('2d');
const areaPerformanceChart = new Chart(areaCtx, {
    type: 'bar',
    data: {
        labels: areaLabels,
        datasets: [
            {
                label: 'QR Entries',
                data: areaQR,
                backgroundColor: '#003366',
                borderColor: '#002244',
                borderWidth: 1
            },
            {
                label: 'SMS Entries',
                data: areaSMS,
                backgroundColor: '#DC143C',
                borderColor: '#B91C3C',
                borderWidth: 1
            }
        ]
    },
    options: {
        responsive: true,
        maintainAspectRatio: false,
        indexAxis: 'y',
        plugins: {
            legend: {
                position: 'top',
                labels: {
                    boxWidth: 12,
                    padding: 20,
                    usePointStyle: true,
                    pointStyle: 'rect'
                }
            },
            tooltip: {
                callbacks: {
                    footer: function(tooltipItems) {
                        let sum = 0;
                        tooltipItems.forEach(function(tooltipItem) {
                            sum += tooltipItem.parsed.x;
                        });
                        return 'Total: ' + sum;
                    }
                }
            }
        },
        scales: {
            x: {
                stacked: true,
                beginAtZero: true,
                grid: {
                    drawBorder: false
                }
            },
            y: {
                stacked: true,
                grid: {
                    display: false
                },
                ticks: {
                    autoSkip: false,
                    maxRotation: 0,
                    minRotation: 0
                }
            }
        },
        elements: {
            bar: {
                borderRadius: 4
            }
        }
    }
});
</script>
</body>
</html>